/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import io.github.reserveword.imblocker.Common;
import io.github.reserveword.imblocker.Config;
import io.github.reserveword.imblocker.FabricCommon;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;

@me.shedaniel.autoconfig.annotation.Config(name="imblocker")
@Environment(value=EnvType.CLIENT)
public class FabricConfig
extends Config
implements ModMenuApi,
ConfigData {
    int checkInterval = 2;
    ArrayList<String> screenBlacklist = new ArrayList<String>(FabricCommon.defaultScreenBlacklist);
    ArrayList<String> screenWhitelist = new ArrayList<String>(FabricCommon.defaultScreenWhitelist);
    ArrayList<String> inputBlacklist = new ArrayList();
    ArrayList<String> inputWhitelist = new ArrayList();
    boolean enableScreenRecovering = false;
    ArrayList<String> recoveredScreens = new ArrayList();
    boolean useExperimental = true;
    boolean checkCommandChat = true;

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> (class_437)AutoConfig.getConfigScreen(FabricConfig.class, (class_437)parent).get();
    }

    public void validatePostLoad() {
        for (List list : Arrays.asList(this.screenBlacklist, this.screenWhitelist, this.inputBlacklist, this.inputWhitelist)) {
            for (int i = 0; i < list.size(); ++i) {
                String cls = (String)list.get(i);
                if (!cls.contains(":")) continue;
                String[] ss = cls.split(":");
                list.set(i, ss[ss.length - 1]);
            }
        }
    }

    @Override
    public boolean inScreenBlacklist(Class<?> cls) {
        return this.screenBlacklist.contains(cls == null ? null : cls.getName());
    }

    @Override
    public boolean inScreenWhitelist(Class<?> cls) {
        return this.screenWhitelist.contains(cls == null ? null : cls.getName());
    }

    @Override
    public boolean inInputBlacklist(Class<?> cls) {
        return this.inputBlacklist.contains(cls == null ? null : cls.getName());
    }

    @Override
    public boolean inInputWhitelist(Class<?> cls) {
        return this.inputWhitelist.contains(cls == null ? null : cls.getName());
    }

    @Override
    public Integer getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public Boolean getUseExperimental() {
        return this.useExperimental;
    }

    @Override
    public Boolean getCheckCommandChat() {
        return this.checkCommandChat;
    }

    @Override
    public void checkScreen(Class<?> cls) {
        if (this.enableScreenRecovering) {
            this.recoveredScreens.add(this.getClassName(cls));
        }
    }

    public String getClassName(Class<?> cls) {
        CodeSource source = cls.getProtectionDomain().getCodeSource();
        if (source == null || cls.getName().startsWith("net.minecraft.")) {
            return "minecraft:" + cls.getName();
        }
        URL locUrl = source.getLocation();
        if (locUrl == null) {
            return cls.getName();
        }
        AtomicReference<String> name = new AtomicReference<String>(cls.getName());
        try {
            URI loc = locUrl.toURI();
            FabricLoader.getInstance().getAllMods().forEach(mod -> {
                String modid = mod.getMetadata().getId();
                try {
                    if (!"minecraft".equals(modid) && !"imblocker".equals(modid) && mod.getRootPaths().stream().anyMatch(path -> path.toUri().equals(loc))) {
                        name.set(modid + ":" + cls.getName());
                    }
                }
                catch (NullPointerException npe) {
                    Common.LOGGER.error("something is null when grabbing mod jar: {}", (Object)mod.getMetadata().getId());
                    Common.LOGGER.error("enableScreenRecovering disabled.");
                    this.enableScreenRecovering = false;
                }
            });
        }
        catch (URISyntaxException e) {
            Common.LOGGER.error((Object)e);
            Common.LOGGER.error("enableScreenRecovering disabled.");
            this.enableScreenRecovering = false;
        }
        return name.get();
    }
}

